#pragma once

#include "Renderable.h"
#include "ShaderProgram.h"
#include <glm/vec3.hpp>
#include <memory>


namespace logic {
	/*!
		the world object describe an object in the world: model, position, orientation, scale of the model
	*/
	class WorldObject
	{
	public:
		/*!
			creates a world objects given the \a model, its \a position in the world, 
			the \a orientation and the \a scale of the model
		*/
		WorldObject(
			graphics::Renderable * model,
			const glm::vec3 & position,
			const glm::vec3 & orientation,
			const glm::vec3 scale);
		~WorldObject();
		/*!
			renders the object
		*/
		void render(graphics::ShaderProgram * program);
		friend class Game;
		graphics::Renderable * m_model;
		glm::vec3 m_position;
		glm::vec3 m_orientation;
		glm::vec3 m_scale;
	};

};